// Test of CiA 401 device


// SVN $Date: 2021-02-26 15:31:18 +0100 (Fr, 26. Feb 2021) $
// SVN $Rev: 35191 $
// SVN $Author: ged $


// configuration settings
const DUT_NodeID = 32

function enableButtons(enable) {
	for(i = 2; i <= 10; i++) {		
		if((i != 7) && (i != 9)) {
			button.setEnabled(i, enable)
		}
	}
}

function saveCanLog() {
	// open a dialog to save file
	f = filedialog.getSaveFileName("Select file to save CAN log","C:/Daten/temp","ZIP (*.zip)");
	if(f != "") {
		util.saveLog(f);
	}
}

function sendFdFrames() {
	var DataArray = new ByteArray(64);
	DataArray[0] = 1;
	DataArray[12] = 12;
	DataArray[63] = 63;


	for (l = 0; l <= 64; l++) {		
		DataArray[1] = l;
		canfd.send(7, false, true, l, DataArray);
	}
}

function prepareButtons() {
	
    button.setName(2, "Send FD Frames")
    button.setEnabled(2, true)
    button.setCommand(2, "sendFdFrames();")

	
    button.setName(8, "Save CAN Log")
    button.setEnabled(8, true)
    button.setCommand(8, "util.after(100, \"saveCanLog()\")")
	
    button.setName(9, "")
    button.setEnabled(9, false)
    button.setCommand(9, "util.clear();")
	
    button.setName(10, "Clear");
    button.setEnabled(10, true)
    button.setCommand(10, "util.clear();")

}

// start scripting here
prepareButtons();

// clear output window
util.clear();
util.print("A small script to send 64 CAN FD frames");

