// UDS test script


// SVN $Date: 2022-10-06 08:10:58 +0200 (Do, 06. Okt 2022) $
// SVN $Rev: 42991 $
// SVN $Author: ged $

// configuration settings
const EXTENDED_ID =  0x20000000 // use 29 bit IDs
var toolCanID     =  0x18da55f9 | EXTENDED_ID;
var deviceCanID   =  0x18daf955 | EXTENDED_ID;
var funcCanID     =  0x18dbfff9 | EXTENDED_ID;

const ID_BOOT_SOFTWARE_IDENTIFICATION = 0xf180;
const ID_APPL_SOFTWARE_IDENTIFICATION = 0xf181;
const ID_APPL_DATA_IDENTIFICATION = 0xf182;
const ID_OPERATION_MODE = 0xfd0c;
const ID_FINGERPRINT = 0xf15a;
const ID_UNSUPPORTED = 0x01fa;


// test ReadByIdentifier functionality
function testReadByIdentifier() {
    testNumber = 1
    util.print("Test " + testNumber + ": Test for ReadByIdentifier (4, 8, and 40 bytes payload)");

    ret = uds.ReadDataByIdentifier(ID_BOOT_SOFTWARE_IDENTIFICATION);
    if (ret === "OK Data") {
        value = uds.getResponseString(3);
        if (value === "1234") {
            util.print("Test " + testNumber + ".1 passed.");
        } else {
            util.print("Test " + testNumber + ".1 failed." + value);
        }
    } else {
        util.print("Test " + testNumber + ".1 failed." + ret);
    }

    ret = uds.ReadDataByIdentifier(ID_APPL_SOFTWARE_IDENTIFICATION);
    if (ret === "OK Data") {
        value = uds.getResponseString(3);
        if (value === "1357abcd") {
            util.print("Test " + testNumber + ".2 passed.");
        } else {
            util.print("Test " + testNumber + ".2 failed." + value);
        }
    } else {
        util.print("Test " + testNumber + ".2 failed." + ret);
    }

    ret = uds.ReadDataByIdentifier(ID_APPL_DATA_IDENTIFICATION);
    if (ret === "OK Data") {
        value = uds.getResponseString(3);
        if (value === "1357abcd__1357abcd__1357abcd__1357abcd__") {
            util.print("Test " + testNumber + ".3 passed.");
        } else {
            util.print("Test " + testNumber + ".3 failed." + value);
        }
    } else {
        util.print("Test " + testNumber + ".3 failed." + ret);
    }

    ret = uds.ReadDataByIdentifier(ID_UNSUPPORTED);
    if (ret === "OK Data") {
        value = uds.getResponseData(0);
        if ((value[0] === 0x7f) && (value[2] === 0x31)) {
            util.print("Test " + testNumber + ".4 passed.");
        } else {
            util.print("Test " + testNumber + ".4 failed.");
        }
    } else {
        util.print("Test " + testNumber + ".4 failed." + ret);
    }

}

// test WriteByIdentifier functionality
function testWriteByIdentifier() {
    testNumber = 2
    util.print("Test " + testNumber + ": Test for WriteByIdentifier (1 and 20 bytes payload, check read back)");

    value = new ByteArray(1);
    compvalue = new ByteArray(1);
    value[0] = 0x5a;

    ret = uds.WriteDataByIdentifier(ID_OPERATION_MODE, value);
    if (ret === "OK Data") {
        ret = uds.ReadDataByIdentifier(ID_OPERATION_MODE);
        if (ret === "OK Data") {
            compvalue = uds.getResponseData(3);
            if (compvalue[0] === value[0]) {
                    util.print("Test " + testNumber + ".1 passed.");
            } else {
                    util.print("Test " + testNumber + ".1 failed. " + compvalue[0]);
            }
        }
    } else {
        util.print("Test " + testNumber + ".1 failed." + ret);
    }

    fp = new ByteArray(20);
    fp[0] = 91;
    fp[5] = 92;
    fp[10] = 93;
    fp[15] = 94;
    fp[19] = 95;
    comp_fp = new ByteArray(20);

    ret = uds.WriteDataByIdentifier(ID_FINGERPRINT, fp);
    if (ret === "OK Data") {
        ret = uds.ReadDataByIdentifier(ID_FINGERPRINT);
        if (ret === "OK Data") {
            comp_fp = uds.getResponseData(3);

            if ((comp_fp[0] === fp[0]) && (comp_fp[15] === fp[15])) {
                    util.print("Test " + testNumber + ".2 passed.");
            } else {
                    util.print("Test " + testNumber + ".2 failed. " + comp_fd[0]);
            }
        }
    } else {
        util.print("Test " + testNumber + ".2 failed." + ret);
    }

    ret = uds.WriteDataByIdentifier(ID_UNSUPPORTED, fp);
    if (ret === "OK Data") {
        value = uds.getResponseData(0);
        if ((value[0] === 0x7f) && (value[2] === 0x31)) {
            util.print("Test " + testNumber + ".3 passed.");
        } else {
            util.print("Test " + testNumber + ".3 failed.");
        }
    } else {
        util.print("Test " + testNumber + ".3 failed." + ret);
    }
}

function testTesterPresent() {
    testNumber = 3

    util.print("Test " + testNumber + ": Test for TesterPresent (response expected and response suppressed)");

    ret = uds.TesterPresent();
    if (ret === "OK Data") {
        value = uds.getResponseData(0);
        if ((value[0] === 0x7e) && (value[1] === 0x00)) {
            util.print("Test " + testNumber + ".1 passed.");
        } else {
            util.print("Test " + testNumber + ".1 failed.");
        }

    } else {
        util.print("Test " + testNumber + ".1 failed." + ret);
    }

    ret = uds.TesterPresent(true);
    if (ret === "OK") {
            util.print("Test " + testNumber + ".2 passed.");
    } else {
            util.print("Test " + testNumber + ".2 failed.");
    }
}

function configureUDSClient() {
    uds.setCanIDs(toolCanID, deviceCanID, 0x7e0);
}

// start scripting here
util.clear()
util.print("Start UDS server test\n")
configureUDSClient();
//for (i = 0; i < 6; i++) {
    testReadByIdentifier();
    testWriteByIdentifier();
    testTesterPresent();
//}
